package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseOpenForBusinessButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🈺",
        description = "Japanese “open for business” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-open-for-business-button", "open-for-business"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “open for business” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseOpenForBusinessButton: Emoji get() = _JapaneseOpenForBusinessButton

/**
 * Alias to emoji [JapaneseOpenForBusinessButton] (Symbols: alphanum: Japanese “open for business” button).
*/
public val Emoji.Companion.OpenForBusiness: Emoji get() = _JapaneseOpenForBusinessButton
