package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAvSymbol() {
    add(intArrayOf(0x1f506), _BrightButton)
    add(intArrayOf(0x1f505), _DimButton)
    add(intArrayOf(0x1f3a6), _Cinema)
    add(intArrayOf(0x1f4f6), _AntennaBars)
    add(intArrayOf(0x1f501), _RepeatButton)
    add(intArrayOf(0x1f502), _RepeatSingleButton)
    add(intArrayOf(0x1f500), _ShuffleTracksButton)
    add(intArrayOf(0x25b6, 0xfe0f), _PlayButton)
    add(intArrayOf(0x25b6), _PlayButton)
    add(intArrayOf(0x23e9), _FastForwardButton)
    add(intArrayOf(0x23ed, 0xfe0f), _NextTrackButton)
    add(intArrayOf(0x23ed), _NextTrackButton)
    add(intArrayOf(0x23ef, 0xfe0f), _PlayOrPauseButton)
    add(intArrayOf(0x23ef), _PlayOrPauseButton)
    add(intArrayOf(0x25c0, 0xfe0f), _ReverseButton)
    add(intArrayOf(0x25c0), _ReverseButton)
    add(intArrayOf(0x23ea), _FastReverseButton)
    add(intArrayOf(0x23ee, 0xfe0f), _LastTrackButton)
    add(intArrayOf(0x23ee), _LastTrackButton)
    add(intArrayOf(0x1f53c), _UpwardsButton)
    add(intArrayOf(0x23eb), _FastUpButton)
    add(intArrayOf(0x1f53d), _DownwardsButton)
    add(intArrayOf(0x23ec), _FastDownButton)
    add(intArrayOf(0x23f8, 0xfe0f), _PauseButton)
    add(intArrayOf(0x23f8), _PauseButton)
    add(intArrayOf(0x23f9, 0xfe0f), _StopButton)
    add(intArrayOf(0x23f9), _StopButton)
    add(intArrayOf(0x23fa, 0xfe0f), _RecordButton)
    add(intArrayOf(0x23fa), _RecordButton)
    add(intArrayOf(0x23cf, 0xfe0f), _EjectButton)
    add(intArrayOf(0x23cf), _EjectButton)
    add(intArrayOf(0x1f4f4), _MobilePhoneOff)
    add(intArrayOf(0x1f6dc), _Wireless)
    add(intArrayOf(0x1f4f3), _VibrationMode)
}

internal fun MutableList<Emoji>.addAllAvSymbol() {
    add(_BrightButton)
    add(_DimButton)
    add(_Cinema)
    add(_AntennaBars)
    add(_RepeatButton)
    add(_RepeatSingleButton)
    add(_ShuffleTracksButton)
    add(_PlayButton)
    add(_FastForwardButton)
    add(_NextTrackButton)
    add(_PlayOrPauseButton)
    add(_ReverseButton)
    add(_FastReverseButton)
    add(_LastTrackButton)
    add(_UpwardsButton)
    add(_FastUpButton)
    add(_DownwardsButton)
    add(_FastDownButton)
    add(_PauseButton)
    add(_StopButton)
    add(_RecordButton)
    add(_EjectButton)
    add(_MobilePhoneOff)
    add(_Wireless)
    add(_VibrationMode)
}

/**
 * All Emoji of the Symbols: av-symbol subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allAvSymbol(): List<Emoji> =
    ArrayList<Emoji>(25).apply { addAllAvSymbol() }
