package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap9: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "9️⃣",
        description = "keycap: 9",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-9", "nine", "keycap-nine"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 9.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap9: Emoji get() = _Keycap9

/**
 * Alias to emoji [Keycap9] (Symbols: keycap: keycap: 9).
*/
public val Emoji.Companion.Nine: Emoji get() = _Keycap9

/**
 * Alias to emoji [Keycap9] (Symbols: keycap: keycap: 9).
*/
public val Emoji.Companion.KeycapNine: Emoji get() = _Keycap9
