package org.kodein.emoji.symbols.warning

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllWarning() {
    add(intArrayOf(0x1f6ab), _Prohibited)
    add(intArrayOf(0x1f6b3), _NoBicycles)
    add(intArrayOf(0x1f6ad), _NoSmoking)
    add(intArrayOf(0x1f6af), _NoLittering)
    add(intArrayOf(0x1f6b1), _NonPotableWater)
    add(intArrayOf(0x1f6b7), _NoPedestrians)
    add(intArrayOf(0x1f4f5), _NoMobilePhones)
    add(intArrayOf(0x1f51e), _NoOneUnderEighteen)
    add(intArrayOf(0x26d4), _NoEntry)
    add(intArrayOf(0x2622, 0xfe0f), _Radioactive)
    add(intArrayOf(0x2622), _Radioactive)
    add(intArrayOf(0x2623, 0xfe0f), _Biohazard)
    add(intArrayOf(0x2623), _Biohazard)
    add(intArrayOf(0x26a0, 0xfe0f), _Warning)
    add(intArrayOf(0x26a0), _Warning)
    add(intArrayOf(0x1f6b8), _ChildrenCrossing)
}

internal fun MutableList<Emoji>.addAllWarning() {
    add(_Prohibited)
    add(_NoBicycles)
    add(_NoSmoking)
    add(_NoLittering)
    add(_NonPotableWater)
    add(_NoPedestrians)
    add(_NoMobilePhones)
    add(_NoOneUnderEighteen)
    add(_NoEntry)
    add(_Radioactive)
    add(_Biohazard)
    add(_Warning)
    add(_ChildrenCrossing)
}

/**
 * All Emoji of the Symbols: warning subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allWarning(): List<Emoji> =
    ArrayList<Emoji>(13).apply { addAllWarning() }
