package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SunBehindLargeCloud: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌥️",
        description = "sun behind large cloud",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("sun-behind-large-cloud", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: sun behind large cloud.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SunBehindLargeCloud: Emoji get() = _SunBehindLargeCloud
