package org.kodein.emoji.activities.event

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ChristmasTree: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎄",
        description = "Christmas tree",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("christmas-tree", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: event: Christmas tree.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ChristmasTree: Emoji get() = _ChristmasTree
