package org.kodein.emoji.animals_nature.animal_bug

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LadyBeetle: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🐞",
        description = "lady beetle",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("lady-beetle", "lady-bug"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Animals & Nature: animal-bug: lady beetle.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LadyBeetle: Emoji get() = _LadyBeetle

/**
 * Alias to emoji [LadyBeetle] (Animals & Nature: animal-bug: lady beetle).
*/
public val Emoji.Companion.LadyBug: Emoji get() = _LadyBeetle
