package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagLebanon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇱🇧",
        description = "flag: Lebanon",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-lebanon", "lebanon-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Lebanon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagLebanon: Emoji get() = _FlagLebanon

/**
 * Alias to emoji [FlagLebanon] (Flags: country-flag: flag: Lebanon).
*/
public val Emoji.Companion.LebanonFlag: Emoji get() = _FlagLebanon
