package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNewZealand: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇿",
        description = "flag: New Zealand",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-new-zealand", "new-zealand-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: New Zealand.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNewZealand: Emoji get() = _FlagNewZealand

/**
 * Alias to emoji [FlagNewZealand] (Flags: country-flag: flag: New Zealand).
*/
public val Emoji.Companion.NewZealandFlag: Emoji get() = _FlagNewZealand
