package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUkraine: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇺🇦",
        description = "flag: Ukraine",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-ukraine", "ukraine-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Ukraine.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUkraine: Emoji get() = _FlagUkraine

/**
 * Alias to emoji [FlagUkraine] (Flags: country-flag: flag: Ukraine).
*/
public val Emoji.Companion.UkraineFlag: Emoji get() = _FlagUkraine
