package org.kodein.emoji.objects.science

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PetriDish: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🧫",
        description = "petri dish",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("petri-dish", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: science: petri dish.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PetriDish: Emoji get() = _PetriDish
