package org.kodein.emoji.objects.sound

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Bell: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔔",
        description = "bell",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("bell", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Objects: sound: bell.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Bell: Emoji get() = _Bell
