package org.kodein.emoji.people_body.person

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _OlderPerson: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧓",
        description = "older person",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("older-person", "elder"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person: older person.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OlderPerson: SkinTone1Emoji get() = _OlderPerson

/**
 * Alias to emoji [OlderPerson] (People & Body: person: older person).
*/
public val Emoji.Companion.Elder: SkinTone1Emoji get() = _OlderPerson
