package org.kodein.emoji.smileys_emotion.face_hat

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DisguisedFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥸",
        description = "disguised face",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("disguised-face", "disguise"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hat: disguised face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DisguisedFace: Emoji get() = _DisguisedFace

/**
 * Alias to emoji [DisguisedFace] (Smileys & Emotion: face-hat: disguised face).
*/
public val Emoji.Companion.Disguise: Emoji get() = _DisguisedFace
