package org.kodein.emoji.smileys_emotion.face_negative

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _AngryFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😠",
        description = "angry face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("angry-face", "angry"),
        emoticons = listOf("X-("),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-negative: angry face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.AngryFace: Emoji get() = _AngryFace

/**
 * Alias to emoji [AngryFace] (Smileys & Emotion: face-negative: angry face).
*/
public val Emoji.Companion.Angry: Emoji get() = _AngryFace
