package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FreeButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆓",
        description = "FREE button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("free-button", "free"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: FREE button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FreeButton: Emoji get() = _FreeButton

/**
 * Alias to emoji [FreeButton] (Symbols: alphanum: FREE button).
*/
public val Emoji.Companion.Free: Emoji get() = _FreeButton
