package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SosButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆘",
        description = "SOS button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("sos-button", "sos"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: SOS button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SosButton: Emoji get() = _SosButton

/**
 * Alias to emoji [SosButton] (Symbols: alphanum: SOS button).
*/
public val Emoji.Companion.Sos: Emoji get() = _SosButton
