package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllArrow() {
    add(intArrayOf(0x2b06, 0xfe0f), _UpArrow)
    add(intArrayOf(0x2b06), _UpArrow)
    add(intArrayOf(0x2197, 0xfe0f), _UpRightArrow)
    add(intArrayOf(0x2197), _UpRightArrow)
    add(intArrayOf(0x27a1, 0xfe0f), _RightArrow)
    add(intArrayOf(0x27a1), _RightArrow)
    add(intArrayOf(0x2198, 0xfe0f), _DownRightArrow)
    add(intArrayOf(0x2198), _DownRightArrow)
    add(intArrayOf(0x2b07, 0xfe0f), _DownArrow)
    add(intArrayOf(0x2b07), _DownArrow)
    add(intArrayOf(0x2199, 0xfe0f), _DownLeftArrow)
    add(intArrayOf(0x2199), _DownLeftArrow)
    add(intArrayOf(0x2b05, 0xfe0f), _LeftArrow)
    add(intArrayOf(0x2b05), _LeftArrow)
    add(intArrayOf(0x2196, 0xfe0f), _UpLeftArrow)
    add(intArrayOf(0x2196), _UpLeftArrow)
    add(intArrayOf(0x2195, 0xfe0f), _UpDownArrow)
    add(intArrayOf(0x2195), _UpDownArrow)
    add(intArrayOf(0x2194, 0xfe0f), _LeftRightArrow)
    add(intArrayOf(0x2194), _LeftRightArrow)
    add(intArrayOf(0x21a9, 0xfe0f), _RightArrowCurvingLeft)
    add(intArrayOf(0x21a9), _RightArrowCurvingLeft)
    add(intArrayOf(0x21aa, 0xfe0f), _LeftArrowCurvingRight)
    add(intArrayOf(0x21aa), _LeftArrowCurvingRight)
    add(intArrayOf(0x2934, 0xfe0f), _RightArrowCurvingUp)
    add(intArrayOf(0x2934), _RightArrowCurvingUp)
    add(intArrayOf(0x2935, 0xfe0f), _RightArrowCurvingDown)
    add(intArrayOf(0x2935), _RightArrowCurvingDown)
    add(intArrayOf(0x1f503), _ClockwiseVerticalArrows)
    add(intArrayOf(0x1f504), _CounterclockwiseArrowsButton)
    add(intArrayOf(0x1f519), _BackArrow)
    add(intArrayOf(0x1f51b), _OnArrow)
    add(intArrayOf(0x1f51d), _TopArrow)
    add(intArrayOf(0x1f51a), _EndArrow)
    add(intArrayOf(0x1f51c), _SoonArrow)
}

internal fun MutableList<Emoji>.addAllArrow() {
    add(_UpArrow)
    add(_UpRightArrow)
    add(_RightArrow)
    add(_DownRightArrow)
    add(_DownArrow)
    add(_DownLeftArrow)
    add(_LeftArrow)
    add(_UpLeftArrow)
    add(_UpDownArrow)
    add(_LeftRightArrow)
    add(_RightArrowCurvingLeft)
    add(_LeftArrowCurvingRight)
    add(_RightArrowCurvingUp)
    add(_RightArrowCurvingDown)
    add(_ClockwiseVerticalArrows)
    add(_CounterclockwiseArrowsButton)
    add(_BackArrow)
    add(_OnArrow)
    add(_TopArrow)
    add(_EndArrow)
    add(_SoonArrow)
}

/**
 * All Emoji of the Symbols: arrow subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allArrow(): List<Emoji> =
    ArrayList<Emoji>(21).apply { addAllArrow() }
