package org.kodein.emoji.symbols.currency

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CurrencyExchange: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💱",
        description = "currency exchange",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("currency-exchange", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: currency: currency exchange.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CurrencyExchange: Emoji get() = _CurrencyExchange
