package org.kodein.emoji.symbols.currency

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HeavyDollarSign: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💲",
        description = "heavy dollar sign",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("heavy-dollar-sign", "dollar-sign"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: currency: heavy dollar sign.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HeavyDollarSign: Emoji get() = _HeavyDollarSign

/**
 * Alias to emoji [HeavyDollarSign] (Symbols: currency: heavy dollar sign).
*/
public val Emoji.Companion.DollarSign: Emoji get() = _HeavyDollarSign
