package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SunBehindSmallCloud: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌤️",
        description = "sun behind small cloud",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("sun-behind-small-cloud", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: sun behind small cloud.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SunBehindSmallCloud: Emoji get() = _SunBehindSmallCloud
