package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GameDie: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎲",
        description = "game die",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("game-die", "die"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: game: game die.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GameDie: Emoji get() = _GameDie

/**
 * Alias to emoji [GameDie] (Activities: game: game die).
*/
public val Emoji.Companion.Die: Emoji get() = _GameDie
