package org.kodein.emoji.animals_nature.animal_bug

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllAnimalBug() {
    add(intArrayOf(0x1f40c), _Snail)
    add(intArrayOf(0x1f98b), _Butterfly)
    add(intArrayOf(0x1f41b), _Bug)
    add(intArrayOf(0x1f41c), _Ant)
    add(intArrayOf(0x1f41d), _Honeybee)
    add(intArrayOf(0x1fab2), _Beetle)
    add(intArrayOf(0x1f41e), _LadyBeetle)
    add(intArrayOf(0x1f997), _Cricket)
    add(intArrayOf(0x1fab3), _Cockroach)
    add(intArrayOf(0x1f577, 0xfe0f), _Spider)
    add(intArrayOf(0x1f577), _Spider)
    add(intArrayOf(0x1f578, 0xfe0f), _SpiderWeb)
    add(intArrayOf(0x1f578), _SpiderWeb)
    add(intArrayOf(0x1f982), _Scorpion)
    add(intArrayOf(0x1f99f), _Mosquito)
    add(intArrayOf(0x1fab0), _Fly)
    add(intArrayOf(0x1fab1), _Worm)
    add(intArrayOf(0x1f9a0), _Microbe)
}

internal suspend fun SequenceScope<Emoji>.yieldAllAnimalBug() {
    yield(_Snail)
    yield(_Butterfly)
    yield(_Bug)
    yield(_Ant)
    yield(_Honeybee)
    yield(_Beetle)
    yield(_LadyBeetle)
    yield(_Cricket)
    yield(_Cockroach)
    yield(_Spider)
    yield(_SpiderWeb)
    yield(_Scorpion)
    yield(_Mosquito)
    yield(_Fly)
    yield(_Worm)
    yield(_Microbe)
}

internal val countAnimalBug = 16

/**
 * All Emoji of the Animals & Nature: animal-bug subgroup.
*/
public fun Emoji.Companion.sequenceAnimalBug(): Sequence<Emoji> =
    sequence { yieldAllAnimalBug() }

/**
 * All Emoji of the Animals & Nature: animal-bug subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listAnimalBug(): List<Emoji> =
    ArrayList<Emoji>(countAnimalBug).also { list -> sequenceAnimalBug().forEach { list.add(it) } }

@Deprecated("Renamed listAnimalBug.", replaceWith = ReplaceWith("listAnimalBug()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allAnimalBug(): List<Emoji> =
    listAnimalBug()
