package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBelize: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇿",
        description = "flag: Belize",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-belize", "belize-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Belize.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBelize: Emoji get() = _FlagBelize

/**
 * Alias to emoji [FlagBelize] (Flags: country-flag: flag: Belize).
*/
public val Emoji.Companion.BelizeFlag: Emoji get() = _FlagBelize
