package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCameroon: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇲",
        description = "flag: Cameroon",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-cameroon", "cameroon-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Cameroon.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCameroon: Emoji get() = _FlagCameroon

/**
 * Alias to emoji [FlagCameroon] (Flags: country-flag: flag: Cameroon).
*/
public val Emoji.Companion.CameroonFlag: Emoji get() = _FlagCameroon
