package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagCongoBrazzaville: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇨🇬",
        description = "flag: Congo - Brazzaville",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-congo-brazzaville", "congo-brazzaville-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.5f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Congo - Brazzaville.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagCongoBrazzaville: Emoji get() = _FlagCongoBrazzaville

/**
 * Alias to emoji [FlagCongoBrazzaville] (Flags: country-flag: flag: Congo - Brazzaville).
*/
public val Emoji.Companion.CongoBrazzavilleFlag: Emoji get() = _FlagCongoBrazzaville
