package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagMalaysia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇲🇾",
        description = "flag: Malaysia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-malaysia", "malaysia-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Malaysia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagMalaysia: Emoji get() = _FlagMalaysia

/**
 * Alias to emoji [FlagMalaysia] (Flags: country-flag: flag: Malaysia).
*/
public val Emoji.Companion.MalaysiaFlag: Emoji get() = _FlagMalaysia
