package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagPalau: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇵🇼",
        description = "flag: Palau",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-palau", "palau-flag"),
        emoticons = listOf(),
        notoImageRatio = 1.6f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Palau.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagPalau: Emoji get() = _FlagPalau

/**
 * Alias to emoji [FlagPalau] (Flags: country-flag: flag: Palau).
*/
public val Emoji.Companion.PalauFlag: Emoji get() = _FlagPalau
