package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSlovenia: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇮",
        description = "flag: Slovenia",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-slovenia", "slovenia-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Slovenia.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSlovenia: Emoji get() = _FlagSlovenia

/**
 * Alias to emoji [FlagSlovenia] (Flags: country-flag: flag: Slovenia).
*/
public val Emoji.Companion.SloveniaFlag: Emoji get() = _FlagSlovenia
