package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSouthGeorgiaSouthSandwichIslands: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇸",
        description = "flag: South Georgia & South Sandwich Islands",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-south-georgia-south-sandwich-islands", "south-georgia-south-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: South Georgia & South Sandwich Islands.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSouthGeorgiaSouthSandwichIslands: Emoji get() = _FlagSouthGeorgiaSouthSandwichIslands

/**
 * Alias to emoji [FlagSouthGeorgiaSouthSandwichIslands] (Flags: country-flag: flag: South Georgia & South Sandwich Islands).
*/
public val Emoji.Companion.SouthGeorgiaSouthFlag: Emoji get() = _FlagSouthGeorgiaSouthSandwichIslands
