package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllClothing() {
    add(intArrayOf(0x1f453), _Glasses)
    add(intArrayOf(0x1f576, 0xfe0f), _Sunglasses)
    add(intArrayOf(0x1f576), _Sunglasses)
    add(intArrayOf(0x1f97d), _Goggles)
    add(intArrayOf(0x1f97c), _LabCoat)
    add(intArrayOf(0x1f9ba), _SafetyVest)
    add(intArrayOf(0x1f454), _Necktie)
    add(intArrayOf(0x1f455), _TShirt)
    add(intArrayOf(0x1f456), _Jeans)
    add(intArrayOf(0x1f9e3), _Scarf)
    add(intArrayOf(0x1f9e4), _Gloves)
    add(intArrayOf(0x1f9e5), _Coat)
    add(intArrayOf(0x1f9e6), _Socks)
    add(intArrayOf(0x1f457), _Dress)
    add(intArrayOf(0x1f458), _Kimono)
    add(intArrayOf(0x1f97b), _Sari)
    add(intArrayOf(0x1fa71), _OnePieceSwimsuit)
    add(intArrayOf(0x1fa72), _Briefs)
    add(intArrayOf(0x1fa73), _Shorts)
    add(intArrayOf(0x1f459), _Bikini)
    add(intArrayOf(0x1f45a), _WomansClothes)
    add(intArrayOf(0x1faad), _FoldingHandFan)
    add(intArrayOf(0x1f45b), _Purse)
    add(intArrayOf(0x1f45c), _Handbag)
    add(intArrayOf(0x1f45d), _ClutchBag)
    add(intArrayOf(0x1f6cd, 0xfe0f), _ShoppingBags)
    add(intArrayOf(0x1f6cd), _ShoppingBags)
    add(intArrayOf(0x1f392), _Backpack)
    add(intArrayOf(0x1fa74), _ThongSandal)
    add(intArrayOf(0x1f45e), _MansShoe)
    add(intArrayOf(0x1f45f), _RunningShoe)
    add(intArrayOf(0x1f97e), _HikingBoot)
    add(intArrayOf(0x1f97f), _FlatShoe)
    add(intArrayOf(0x1f460), _HighHeeledShoe)
    add(intArrayOf(0x1f461), _WomansSandal)
    add(intArrayOf(0x1fa70), _BalletShoes)
    add(intArrayOf(0x1f462), _WomansBoot)
    add(intArrayOf(0x1faae), _HairPick)
    add(intArrayOf(0x1f451), _Crown)
    add(intArrayOf(0x1f452), _WomansHat)
    add(intArrayOf(0x1f3a9), _TopHat)
    add(intArrayOf(0x1f393), _GraduationCap)
    add(intArrayOf(0x1f9e2), _BilledCap)
    add(intArrayOf(0x1fa96), _MilitaryHelmet)
    add(intArrayOf(0x26d1, 0xfe0f), _RescueWorkersHelmet)
    add(intArrayOf(0x26d1), _RescueWorkersHelmet)
    add(intArrayOf(0x1f4ff), _PrayerBeads)
    add(intArrayOf(0x1f484), _Lipstick)
    add(intArrayOf(0x1f48d), _Ring)
    add(intArrayOf(0x1f48e), _GemStone)
}

internal suspend fun SequenceScope<Emoji>.yieldAllClothing() {
    yield(_Glasses)
    yield(_Sunglasses)
    yield(_Goggles)
    yield(_LabCoat)
    yield(_SafetyVest)
    yield(_Necktie)
    yield(_TShirt)
    yield(_Jeans)
    yield(_Scarf)
    yield(_Gloves)
    yield(_Coat)
    yield(_Socks)
    yield(_Dress)
    yield(_Kimono)
    yield(_Sari)
    yield(_OnePieceSwimsuit)
    yield(_Briefs)
    yield(_Shorts)
    yield(_Bikini)
    yield(_WomansClothes)
    yield(_FoldingHandFan)
    yield(_Purse)
    yield(_Handbag)
    yield(_ClutchBag)
    yield(_ShoppingBags)
    yield(_Backpack)
    yield(_ThongSandal)
    yield(_MansShoe)
    yield(_RunningShoe)
    yield(_HikingBoot)
    yield(_FlatShoe)
    yield(_HighHeeledShoe)
    yield(_WomansSandal)
    yield(_BalletShoes)
    yield(_WomansBoot)
    yield(_HairPick)
    yield(_Crown)
    yield(_WomansHat)
    yield(_TopHat)
    yield(_GraduationCap)
    yield(_BilledCap)
    yield(_MilitaryHelmet)
    yield(_RescueWorkersHelmet)
    yield(_PrayerBeads)
    yield(_Lipstick)
    yield(_Ring)
    yield(_GemStone)
}

internal val countClothing = 47

/**
 * All Emoji of the Objects: clothing subgroup.
*/
public fun Emoji.Companion.sequenceClothing(): Sequence<Emoji> =
    sequence { yieldAllClothing() }

/**
 * All Emoji of the Objects: clothing subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listClothing(): List<Emoji> =
    ArrayList<Emoji>(countClothing).also { list -> sequenceClothing().forEach { list.add(it) } }

@Deprecated("Renamed listClothing.", replaceWith = ReplaceWith("listClothing()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allClothing(): List<Emoji> =
    listClothing()
