package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DesktopComputer: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🖥️",
        description = "desktop computer",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("desktop-computer", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: computer: desktop computer.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DesktopComputer: Emoji get() = _DesktopComputer
