package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DollarBanknote: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💵",
        description = "dollar banknote",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("dollar-banknote", "dollar"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: money: dollar banknote.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DollarBanknote: Emoji get() = _DollarBanknote

/**
 * Alias to emoji [DollarBanknote] (Objects: money: dollar banknote).
*/
public val Emoji.Companion.Dollar: Emoji get() = _DollarBanknote
