package org.kodein.emoji.objects.money

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MoneyWithWings: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💸",
        description = "money with wings",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("money-with-wings", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Objects: money: money with wings.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MoneyWithWings: Emoji get() = _MoneyWithWings
