package org.kodein.emoji.objects.music

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _LevelSlider: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎚️",
        description = "level slider",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("level-slider", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: music: level slider.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.LevelSlider: Emoji get() = _LevelSlider
