package org.kodein.emoji.objects.music

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MusicalNotes: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎶",
        description = "musical notes",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("musical-notes", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Objects: music: musical notes.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MusicalNotes: Emoji get() = _MusicalNotes
