package org.kodein.emoji.smileys_emotion.face_concerned

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WearyFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "😩",
        description = "weary face",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("weary-face", "weary"),
        emoticons = listOf("D:"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-concerned: weary face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WearyFace: Emoji get() = _WearyFace

/**
 * Alias to emoji [WearyFace] (Smileys & Emotion: face-concerned: weary face).
*/
public val Emoji.Companion.Weary: Emoji get() = _WearyFace
