package org.kodein.emoji.smileys_emotion.face_costume

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceCostume() {
    add(intArrayOf(0x1f4a9), _PileOfPoo)
    add(intArrayOf(0x1f921), _ClownFace)
    add(intArrayOf(0x1f479), _Ogre)
    add(intArrayOf(0x1f47a), _Goblin)
    add(intArrayOf(0x1f47b), _Ghost)
    add(intArrayOf(0x1f47d), _Alien)
    add(intArrayOf(0x1f47e), _AlienMonster)
    add(intArrayOf(0x1f916), _Robot)
}

internal suspend fun SequenceScope<Emoji>.yieldAllFaceCostume() {
    yield(_PileOfPoo)
    yield(_ClownFace)
    yield(_Ogre)
    yield(_Goblin)
    yield(_Ghost)
    yield(_Alien)
    yield(_AlienMonster)
    yield(_Robot)
}

internal val countFaceCostume = 8

/**
 * All Emoji of the Smileys & Emotion: face-costume subgroup.
*/
public fun Emoji.Companion.sequenceFaceCostume(): Sequence<Emoji> =
    sequence { yieldAllFaceCostume() }

/**
 * All Emoji of the Smileys & Emotion: face-costume subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listFaceCostume(): List<Emoji> =
    ArrayList<Emoji>(countFaceCostume).also { list -> sequenceFaceCostume().forEach { list.add(it) } }

@Deprecated("Renamed listFaceCostume.", replaceWith = ReplaceWith("listFaceCostume()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allFaceCostume(): List<Emoji> =
    listFaceCostume()
