package org.kodein.emoji.smileys_emotion.face_hat

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PartyingFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥳",
        description = "partying face",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("partying-face", ),
        emoticons = listOf("(ﾉ◕ヮ◕)♬♪"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hat: partying face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PartyingFace: Emoji get() = _PartyingFace
