package org.kodein.emoji.smileys_emotion.face_neutral_skeptical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ZipperMouthFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤐",
        description = "zipper-mouth face",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("zipper-mouth-face", "zipper-face"),
        emoticons = listOf(":#"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-neutral-skeptical: zipper-mouth face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ZipperMouthFace: Emoji get() = _ZipperMouthFace

/**
 * Alias to emoji [ZipperMouthFace] (Smileys & Emotion: face-neutral-skeptical: zipper-mouth face).
*/
public val Emoji.Companion.ZipperFace: Emoji get() = _ZipperMouthFace
