package org.kodein.emoji.smileys_emotion.face_unwell

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WoozyFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥴",
        description = "woozy face",
        unicodeVersion = UnicodeVersion(11, 0),
        aliases = listOf("woozy-face", "woozy"),
        emoticons = listOf(">﹏☉"),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: face-unwell: woozy face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WoozyFace: Emoji get() = _WoozyFace

/**
 * Alias to emoji [WoozyFace] (Smileys & Emotion: face-unwell: woozy face).
*/
public val Emoji.Companion.Woozy: Emoji get() = _WoozyFace
