package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GreenHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💚",
        description = "green heart",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("green-heart", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: green heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GreenHeart: Emoji get() = _GreenHeart
