package org.kodein.emoji.symbols.currency

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllCurrency() {
    add(intArrayOf(0x1f4b1), _CurrencyExchange)
    add(intArrayOf(0x1f4b2), _HeavyDollarSign)
}

internal suspend fun SequenceScope<Emoji>.yieldAllCurrency() {
    yield(_CurrencyExchange)
    yield(_HeavyDollarSign)
}

internal val countCurrency = 2

/**
 * All Emoji of the Symbols: currency subgroup.
*/
public fun Emoji.Companion.sequenceCurrency(): Sequence<Emoji> =
    sequence { yieldAllCurrency() }

/**
 * All Emoji of the Symbols: currency subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listCurrency(): List<Emoji> =
    ArrayList<Emoji>(countCurrency).also { list -> sequenceCurrency().forEach { list.add(it) } }

@Deprecated("Renamed listCurrency.", replaceWith = ReplaceWith("listCurrency()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allCurrency(): List<Emoji> =
    listCurrency()
