package org.kodein.emoji.symbols.gender

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllGender() {
    add(intArrayOf(0x2640, 0xfe0f), _FemaleSign)
    add(intArrayOf(0x2640), _FemaleSign)
    add(intArrayOf(0x2642, 0xfe0f), _MaleSign)
    add(intArrayOf(0x2642), _MaleSign)
    add(intArrayOf(0x26a7, 0xfe0f), _TransgenderSymbol)
    add(intArrayOf(0x26a7), _TransgenderSymbol)
}

internal suspend fun SequenceScope<Emoji>.yieldAllGender() {
    yield(_FemaleSign)
    yield(_MaleSign)
    yield(_TransgenderSymbol)
}

internal val countGender = 3

/**
 * All Emoji of the Symbols: gender subgroup.
*/
public fun Emoji.Companion.sequenceGender(): Sequence<Emoji> =
    sequence { yieldAllGender() }

/**
 * All Emoji of the Symbols: gender subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.listGender(): List<Emoji> =
    ArrayList<Emoji>(countGender).also { list -> sequenceGender().forEach { list.add(it) } }

@Deprecated("Renamed listGender.", replaceWith = ReplaceWith("listGender()"), level = DeprecationLevel.WARNING)
public fun Emoji.Companion.allGender(): List<Emoji> =
    listGender()
