package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap5: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "5️⃣",
        description = "keycap: 5",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-5", "five", "keycap-five"),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 5.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap5: Emoji get() = _Keycap5

/**
 * Alias to emoji [Keycap5] (Symbols: keycap: keycap: 5).
*/
public val Emoji.Companion.Five: Emoji get() = _Keycap5

/**
 * Alias to emoji [Keycap5] (Symbols: keycap: keycap: 5).
*/
public val Emoji.Companion.KeycapFive: Emoji get() = _Keycap5
