package org.kodein.emoji.symbols.keycap

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Keycap8: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "8️⃣",
        description = "keycap: 8",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("keycap-8", "eight", "keycap-eight"),
        emoticons = listOf(),
        notoImageRatio = 0.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: keycap: keycap: 8.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Keycap8: Emoji get() = _Keycap8

/**
 * Alias to emoji [Keycap8] (Symbols: keycap: keycap: 8).
*/
public val Emoji.Companion.Eight: Emoji get() = _Keycap8

/**
 * Alias to emoji [Keycap8] (Symbols: keycap: keycap: 8).
*/
public val Emoji.Companion.KeycapEight: Emoji get() = _Keycap8
