package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Sun: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "☀️",
        description = "sun",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("sun", "sunny"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: sun.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Sun: Emoji get() = _Sun

/**
 * Alias to emoji [Sun] (Travel & Places: sky & weather: sun).
*/
public val Emoji.Companion.Sunny: Emoji get() = _Sun
