package org.kodein.emoji.travel_places.sky_weather

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WindFace: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🌬️",
        description = "wind face",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("wind-face", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 1.0f,
    ),
)

/**
 * Emoji Travel & Places: sky & weather: wind face.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WindFace: Emoji get() = _WindFace
