package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HourglassNotDone: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⏳",
        description = "hourglass not done",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("hourglass-not-done", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: time: hourglass not done.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HourglassNotDone: Emoji get() = _HourglassNotDone
