package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _NestingDolls: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🪆",
        description = "nesting dolls",
        unicodeVersion = UnicodeVersion(13, 0),
        aliases = listOf("nesting-dolls", "nesting-doll"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: game: nesting dolls.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.NestingDolls: Emoji get() = _NestingDolls

/**
 * Alias to emoji [NestingDolls] (Activities: game: nesting dolls).
*/
public val Emoji.Companion.NestingDoll: Emoji get() = _NestingDolls
